/*
Constraints assignment MacroScript File
Constraint tools
This script increases workflow on assigning constraints by adding a controller automatically.

-- Aug 15 added prompting
-- Aug 20 added LinkConstraint
-- Nov 6  added "H" key support ForceListenerFocus
-- Dec 14 Added Biped Support  
-- Dec 18 Fixed LookAt, Orientation and Noise Rotation constraints - passing wrong channel to AddConstraint
-- Jan 4  Added support for HI IK and HD IK objects; Added group support
-- Feb 16 04 Attachment filter fnc detects attaching controller to self
-- Feb 18 04 Added check for return value of constraint.AppendTarget
-- Feb 23 04 Updated pick filter of constraints to use DependencyLoopTest 


Author :   Frank DeLise
Version:  3ds max 6

Revision History:

	11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products


***********************************************************************************************
 MODIFY THIS AT YOUR OWN RISK

*/

MacroScript Path
	ButtonText:~PATH_BUTTONTEXT~
	Category:~PATH_CATEGORY~ 
	internalCategory:"Constraints" 
	Tooltip:~PATH_TOOLTIP~ 
	SilentErrors:(Debug != false)

(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)
	 
	on execute do 
	(
		AssignConstraintSelection Path ~PATH_POS_CAPTION~ Position_List ShapeFilterFn ~SHAPEFILTERFN_PICK_SHAPE_CAPTION~ ~SHAPEFILTERFN_PATH_CONSTRAINT_NOT_COMPLETED_CAPTION~
	)
)


MacroScript LinkConstraint
	ButtonText:~LINKCONSTRAINT_BUTTONTEXT~
	Category:~LINKCONSTRAINT_CATEGORY~ 
	internalCategory:"Constraints" 
	Tooltip:~LINKCONSTRAINT_TOOLTIP~ 
	SilentErrors:(Debug != True)
	
(
	Global EC_TargetOBJ = ~EC_TARGETOBJ_NONE_CAPTION~

	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)
	 
	on execute do 
	(
		Try
		(
			-------------------------------------------------------------------------------------------
			-- Switch to Motion Panel
			-------------------------------------------------------------------------------------------
		
			IF selection.count == 1 AND getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
			
			-------------------------------------------------------------------------------------------
					
			EC_TargetOBJ = PickObject count:1 filter:ConstrFilterFn message:~EC_TARGETOBJ_PICK_CAPTION~ Rubberband:selection[1].transform.pos ForceListenerFocus:False
			if EC_TargetOBJ != undefined and EC_TargetOBJ != "None" then
			(
				for node in selection do
				(
					local controllerClass = classof node.controller
					if not (controllerClass == BipSlave_Control or
							controllerClass == XRef_Controller or
							(controllerClass == IK_ControllerMatrix3Controller and 
							 node.controller[1].controller == undefined)) then
					(
						-------------------------------------------------------------------------------------------
						-- Skip group members, only apply to head
						-------------------------------------------------------------------------------------------
						local h = node.parent 
						if not (h != undefined and h.isSelected and isGroupHead h) then
						(
							---------------------------------------------------------------------------------------
							-- Add Constraint 
							-- If it's not a link constraint already, check for IK object and IK goal object
							---------------------------------------------------------------------------------------	
							local constraint
							if Classof node.controller == IKControl then 
							(
								constraint = node.Transform.controller.fk_sub_control.controller
							)
							else if Classof node.controller == IKChainControl then 
							(
								constraint = node.Transform.controller.ik_goal.controller
							)	
							else 
							(
								constraint = node.Transform.controller
							)
							If Classof constraint != Link_Constraint do 
							(
								constraint = Link_Constraint ()
								if Classof node.controller == IKControl then 
								(
									node.Transform.controller.fk_sub_control.controller = constraint
								)
								else if Classof node.controller == IKChainControl then 
								(
									node.Transform.controller.ik_goal.controller = constraint
								)	
								else 
								(
									node.Transform.controller = constraint
								)
							)
							
							---------------------------------------------------------------------------------------
							-- Add Links to Link Constraint
							---------------------------------------------------------------------------------------
							local res = true;
							if Classof node.controller == IKControl then 
							(
								res = node.controller.fk_sub_control.controller.AddTarget EC_TargetOBJ SliderTime
							)
							else if Classof node.controller == IKChainControl then 
							(
								res = node.controller.ik_goal.controller.AddTarget EC_TargetOBJ SliderTime
							)	
							else
							(
								res = node.Transform.controller.AddTarget EC_TargetOBJ SliderTime
							)
									
							if (res != true) then 
							(
								throw 0
							)
						)
					)
				)
			)
		)
		Catch (MessageBox ~MSGBOX_LINK_CONSTRAINT_NOT_COMPLETED_CAPTION~ Title:~MSGBOX_LINK_CONSTRAINTS_TITLE~)
	)
)


MacroScript Position_Constraint
	ButtonText:~POSITION_CONSTRAINT_BUTTONTEXT~
	Category:~POSITION_CONSTRAINT_CATEGORY~ 
	internalCategory:"Constraints" 
	Tooltip:~POSITION_CONSTRAINT_TOOLTIP~ 
	SilentErrors:(Debug != True)

(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)
	 
	on execute do 
	(			
		AssignConstraintSelection Position_Constraint ~POSITION_CONSTRAINT_CAPTION~ Position_List ConstrFilterFn ~CONSTRFILTERFN_CAPTION~ ~CONSTRFILTERFN_POS_CONSTRAINT_NOT_COMPLETED_CAPTION~
	)
)


MacroScript Orientation_Constraint
	ButtonText:~ORIENTATION_CONSTRAINT_BUTTONTEXT~
	Category:~ORIENTATION_CONSTRAINT_CATEGORY~ 
	internalCategory:"Constraints" 
	Tooltip:~ORIENTATION_CONSTRAINT_TOOLTIP~ 
	SilentErrors:(Debug != True)

(
	-- Check to see if something valid is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)
	 
	on execute do 
	(
		AssignConstraintSelection Orientation_Constraint ~ORIENTATION_CONSTRAINT_ROTATION~ Rotation_List ConstrFilterFn ~CONSTRFILTERFN_PICK_OBJ_CAPTION~ ~CONSTRFILTERFN_ORIENTATION_CONSTRAINT_CAPTION~
	)
)


MacroScript LookAt
	ButtonText:~LOOKAT_BUTTONTEXT~
	Category:~LOOKAT_CATEGORY~ 
	internalCategory:"Constraints" 
	Tooltip:~LOOKAT_TOOLTIP~
	SilentErrors:(Debug != True) 

(
	-- Check to see if something valid is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)
	 
	on execute do 
	(
		AssignConstraintSelection LookAt_Constraint ~LOOKAT_CONSTRAINT_ROTATION_CAPTION~ Rotation_List ConstrFilterFn ~CONSTRFILTERFN_PICK_OBJ_LOOK_AT_CAPTION~ ~CONSTRFILTERFN_LOOKAT_CONSTRAINT_CAPTION~
	)
)


MacroScript Attachment
	ButtonText:~ATTACHMENT_BUTTONTEXT~
	Category:~ATTACHMENT_CATEGORY~ 
	internalCategory:"Constraints" 
	Tooltip:~ATTACHMENT_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	Global EC_TargetOBJ = ~ATTACHMENT_EC_TARGETOBJ_NONE_CAPTION~
	
	-- Check to see if something valid is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		Try
		(
			-------------------------------------------------------------------------------------------
			-- Switch to Motion Panel
			-------------------------------------------------------------------------------------------
		
			IF selection.count == 1 AND getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
			
			-------------------------------------------------------------------------------------------
					
			EC_TargetOBJ = PickObject count:1 filter:GeomFilterFn message:~EC_TARGETOBJ_PICK_OBJ_TO_ATTACH_TO_CAPTION~ Rubberband:selection[1].transform.pos ForceListenerFocus:False
			if EC_TargetOBJ != undefined and EC_TargetOBJ != "None" then
			(
				for node in selection do
				(
					local controllerClass = classof node.controller
					if not (controllerClass == BipSlave_Control or
							controllerClass == XRef_Controller or
							(controllerClass == IK_ControllerMatrix3Controller and 
							 node.controller[1].controller == undefined)) then
					(
						-------------------------------------------------------------------------------------------
						-- Skip group members, only apply to head
						-------------------------------------------------------------------------------------------
						local h = node.parent 
						if not (h != undefined and h.isSelected and isGroupHead h) then
						(
							if (refs.DependencyLoopTest EC_TargetOBJ node.controller != true) then
							(
								-------------------------------------------------------------------------------------------
								-- Add List Controller
								-------------------------------------------------------------------------------------------
								
								local cont = AddListController node "Pos" Position_List 
								
								-------------------------------------------------------------------------------------------
								-- Add Constraint
								---------------------------------------------------------------------------------------
								If classof cont[listCtrl.GetActive cont].object != Attachment then 
								(
									constraint = AddConstraint node "Pos" Attachment true
								)
								else 
								(
									constraint = cont[listCtrl.GetActive cont].object
								)
						
								-------------------------------------------------------------------------------------------
								-- Set Node Attached To, initial key
								-------------------------------------------------------------------------------------------
								constraint.Node = EC_TargetOBJ
								local key = AttachCtrl.addnewkey constraint 0
								key.face = 1
					
								-------------------------------------------------------------------------------------------
								-- Set Active Controller
								-------------------------------------------------------------------------------------------
										
								SetActiveController cont constraint
																		
								--Format "%\n"  (node.name + ~FORMATTED_STRING_IS_ATTACHED_TO~ + EC_TargetOBJ.name) to:Listener
							)
						)
					)
				)
			)			
		)
		Catch (MessageBox ~MSGBOX_ATTACHMENT_CONSTRAINT_NOT_COMPLETED_CAPTION~ Title:~MSGBOX_ATTACHMENT_CONSTRAINTS_TITLE~)
	)
)


MacroScript Surface
	ButtonText:~SURFACE_BUTTONTEXT~
	Category:~SURFACE_CATEGORY~ 
	internalCategory:"Constraints" 
	Tooltip:~SURFACE_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	Local ConstraintCompleted = False
	Global EC_TargetOBJ = ~GLOBAL_EC_TARGETOBJ_NONE_CAPTION~
	
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		Undo on
		(
			Try 
			(
				-------------------------------------------------------------------------------------------
				-- Switch to Motion Panel
				-------------------------------------------------------------------------------------------
			
				IF selection.count == 1 AND getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
			
		
				-------------------------------------------------------------------------------------------
						
				EC_TargetOBJ = PickObject count:1 filter:SurfaceFilterFn message:~EC_TARGETOBJ_PICK_SURFACE_CAPTION~ Rubberband:selection[1].transform.pos ForceListenerFocus:False
				if EC_TargetOBJ != undefined and EC_TargetOBJ != "None" then
				(
					for node in selection do
					(
						local controllerClass = classof node.controller
						if not (controllerClass == BipSlave_Control or
								controllerClass == XRef_Controller or
								(controllerClass == IK_ControllerMatrix3Controller and 
								 node.controller[1].controller == undefined)) then
						(
							-------------------------------------------------------------------------------------------
							-- Skip group members, only apply to head
							-------------------------------------------------------------------------------------------
							local h = node.parent 
							if not (h != undefined and h.isSelected and isGroupHead h) then
							(
								if (refs.DependencyLoopTest EC_TargetOBJ node.controller != true) then
								(
									-------------------------------------------------------------------------------------------
									-- Add List Controller
									-------------------------------------------------------------------------------------------
									
									local cont = AddListController node "Pos" Position_List 
									
									-------------------------------------------------------------------------------------------
									-- Add Constraint
									---------------------------------------------------------------------------------------
									If classof cont[listCtrl.GetActive cont].object != Surface_Position then 
									(
										constraint = AddConstraint node "Pos" Surface_Position true
									)
									else 
									(
										constraint = cont[listCtrl.GetActive cont].object
									)
									
									-------------------------------------------------------------------------------------------
									-- Add Object
									-------------------------------------------------------------------------------------------
										
									constraint.Surface = EC_TargetOBJ
										
									-------------------------------------------------------------------------------------------
									-- Set Active Controller
									-------------------------------------------------------------------------------------------
											
									SetActiveController cont constraint
								)
							)
						)
					)
				)
			)
			Catch (MessageBox ~SURFACE_CONSTRAINT_NOT_COMPLETED~ Title:~MSGBOX_CONSTRAINTS_TITLE~)
		)
	)
)



MacroScript Bezier_P
	ButtonText:~BEZIER_P_BUTTONTEXT~
	Category:~BEZIER_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~BEZIER_P_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Bezier_Position ~BEZIER_POSITION_POS_CAPTION~ Position_List ~BEZIER_POSITION_POS_LIST_CAPTION~
	)
)

MacroScript Bezier_S
	ButtonText:~BEZIER_S_BUTTONTEXT~
	Category:~BEZIER_S_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~BEZIER_S_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Bezier_Scale ~BEZIER_SCALE_CAPTION~ Scale_List ~BEZIER_SCALE_CONTROLLER_NOT_COMPLETED_CAPTION~
	)
)



MacroScript Noise_P
	ButtonText:~NOISE_P_BUTTONTEXT~
	Category:~NOISE_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~NOISE_P_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Noise_Position ~NOISE_POSITION_CAPTION~ Position_List ~POSITION_LIST_CAPTION~
	)
)


MacroScript Noise_R
	ButtonText:~NOISE_R_BUTTONTEXT~
	Category:~NOISE_R_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~NOISE_R_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Noise_Rotation ~NOISE_ROTATION_CAPTION~ Rotation_List ~ROTATION_LIST_CAPTION~
	)
)

	
MacroScript Noise_S
	ButtonText:~NOISE_S_BUTTONTEXT~
	Category:~NOISE_S_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~NOISE_S_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Noise_Scale ~NOISE_SCALE_CAPTION~ Scale_List ~SCALE_LIST_CAPTION~
	)
)

MacroScript Audio_P
	ButtonText:~AUDIO_P_BUTTONTEXT~
	Category:~AUDIO_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~AUDIO_P_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection AudioPosition ~AUDIOPOSITION_CAPTION~ Position_List ~POSITION_LIST_AUDIO_CONTROLLER_CAPTION~
	)
)
	

MacroScript Audio_R
	ButtonText:~AUDIO_R_BUTTONTEXT~
	Category:~AUDIO_R_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~AUDIO_R_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection AudioRotation ~AUDIOROTATION_CAPTION~ Rotation_List ~ROTATION_LIST_CONTROLLER_NOT_COMPLETED_CAPTION~
	)
)


MacroScript Audio_S
	ButtonText:~AUDIO_S_BUTTONTEXT~
	Category:~AUDIO_S_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~AUDIO_S_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection AudioScale ~AUDIOSCALE_CAPTION~ Scale_List ~SCALE_LIST_CONTROLLER_NOT_COMPLETED~
	)
)

MacroScript Linear_P
	ButtonText:~LINEAR_P_BUTTONTEXT~
	Category:~LINEAR_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~LINEAR_P_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Linear_Position ~LINEAR_POSITION_CAPTION~ Position_List ~POSITION_LIST_CONTROLLER_CAPTION~
	)
)




MacroScript Linear_R
	ButtonText:~LINEAR_R_BUTTONTEXT~
	Category:~LINEAR_R_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~LINEAR_R_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Linear_Rotation ~LINEAR_R_CAPTION~ Rotation_List ~LINEAR_R_LIST_CAPTION~
	)
)


MacroScript Linear_S
	ButtonText:~LINEAR_S_BUTTONTEXT~
	Category:~LINEAR_S_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~LINEAR_S_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Linear_Scale ~LINEAR_SCALE_CAPTION~ Scale_List ~LINEAR_SCALE_LIST_CAPTION~
	)
)


MacroScript Expression_P
	ButtonText:~EXPRESSION_P_BUTTONTEXT~
	Category:~EXPRESSION_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~EXPRESSION_P_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Position_Expression ~POSITION_EXPRESSION_CAPTION~ Position_List ~POSITION_EXPRESSION_LIST_CAPTION~
	)
)



MacroScript Expression_S
	ButtonText:~EXPRESSION_S_BUTTONTEXT~
	Category:~EXPRESSION_S_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~EXPRESSION_S_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Scale_Expression ~SCALE_EXPRESSION_CAPTION~ Scale_List ~EXPRESSION_S_LIST_CAPTION~
	)
)


MacroScript Mocap_P
	ButtonText:~MOCAP_P_BUTTONTEXT~
	Category:~MOCAP_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~MOCAP_P_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Position_Motion_Capture ~POSITION_MOTION_CAPTURE_CAPTION~ Position_List ~POSITION_MOTION_CAPTURE_LIST_CAPTION~
	)
)




MacroScript Mocap_R
	ButtonText:~MOCAP_R_BUTTONTEXT~
	Category:~MOCAP_R_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~MOCAP_R_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Rotation_Motion_Capture ~ROTATION_MOTION_CAPTURE_CAPTION~ Rotation_List ~ROTATION_MOTION_CAPTURE_LIST~
	)
)


MacroScript Mocap_S
	ButtonText:~MOCAP_S_BUTTONTEXT~
	Category:~MOCAP_S_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~MOCAP_S_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Scale_Motion_Capture ~SCALE_MOTION_CAPTURE_CAPTION~ Scale_List ~SCALE_MOTION_CAPTURE_LIST_CAPTION~
	)
)


MacroScript Reactor_P
	ButtonText:~REACTOR_P_BUTTONTEXT~
	Category:~REACTOR_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~REACTOR_P_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Position_Reactor ~POSITION_REACTOR_CAPTION~ Position_List ~POSITION_REACTOR_LIST_CAPTION~
	)
)




MacroScript Reactor_R
	ButtonText:~REACTOR_R_BUTTONTEXT~
	Category:~REACTOR_R_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~REACTOR_R_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Rotation_Reactor ~ROTATION_REACTOR_CAPTION~ Rotation_List ~ROTATION_REACTOR_LIST_CAPTION~
	)
)


MacroScript Reactor_S
	ButtonText:~REACTOR_S_BUTTONTEXT~
	Category:~REACTOR_S_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~REACTOR_S_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Scale_Reactor ~SCALE_REACTOR_CAPTION~ Scale_List ~SCALE_REACTOR_LIST_CAPTION~
	)
)


MacroScript Script_P
	ButtonText:~SCRIPT_P_BUTTONTEXT~
	Category:~SCRIPT_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~SCRIPT_P_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Position_Script ~POSITION_SCRIPT_CAPTION~ Position_List ~POSITION_SCRIPT_LIST_CAPTION~
	)
)




MacroScript Script_R
	ButtonText:~SCRIPT_R_BUTTONTEXT~
	Category:~SCRIPT_R_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~SCRIPT_R_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Rotation_Script ~ROTATION_SCRIPT_CAPTION~ Rotation_List ~ROTATION_SCRIPT_LIST_CAPTION~
	)
)


MacroScript Script_S
	ButtonText:~SCRIPT_S_BUTTONTEXT~
	Category:~SCRIPT_S_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~SCRIPT_S_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Scale_Script ~SCALE_SCRIPT_CAPTION~ Scale_List ~SCALE_SCRIPT_LIST_CAPTION~
	)
)


MacroScript XYZ_P
	ButtonText:~XYZ_P_BUTTONTEXT~
	Category:~XYZ_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~XYZ_P_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Position_XYZ ~POSITION_XYZ_CAPTION~ Position_List ~POSITION_XYZ_LIST_CAPTION~
	)
)




MacroScript EulerXYZ_R
	ButtonText:~EULERXYZ_R_BUTTONTEXT~
	Category:~EULERXYZ_R_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~EULERXYZ_R_TOOLTIP~
	SilentErrors:(Debug != True) 
	
(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection Euler_XYZ ~EULER_XYZ_CAPTION~ Rotation_List ~EULER_XYZ_LIST_CAPTION~
	)
)


MacroScript XYZ_S
	ButtonText:~XYZ_S_BUTTONTEXT~
	Category:~XYZ_S_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~XYZ_S_TOOLTIP~
	SilentErrors:(Debug != True) 
	
(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection ScaleXYZ ~SCALEXYZ_CAPTION~ Scale_List ~SCALEXYZ_LIST_CAPTION~
	)
)

MacroScript Slave_P
	ButtonText:~SLAVE_P_BUTTONTEXT~
	Category:~SLAVE_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~SLAVE_P_TOOLTIP~
	SilentErrors:(Debug != True) 

(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection SlavePos ~SLAVEPOS_CAPTION~ Position_List ~SLAVEPOS_LIST_CAPTION~			
	)
)




MacroScript Slave_R
	ButtonText:~SLAVE_R_BUTTONTEXT~
	Category:~SLAVE_R_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~SLAVE_R_TOOLTIP~
	SilentErrors:(Debug != True) 

(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection SlaveRotation ~SLAVEROTATION_CAPTION~ Rotation_List ~SLAVEROTATION_LIST_CAPTION~
	)
)


MacroScript Slave_S
	ButtonText:~SLAVE_S_BUTTONTEXT~
	Category:~SLAVE_S_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~SLAVE_S_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection SlaveScale ~SLAVESCALE_CAPTION~ Scale_List ~SLAVESCALE_LIST_CAPTION~
	)
)

MacroScript Spring_P
	ButtonText:~SPRING_P_BUTTONTEXT~
	Category:~SPRING_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~SPRING_P_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection SpringPositionController ~SPRINGPOSITIONCONTROLLER_CAPTION~ Position_List ~SPRINGPOSITIONCONTROLLER_LIST_CAPTION~			
	)
)




MacroScript Smooth_R
	ButtonText:~SMOOTH_R_BUTTONTEXT~
	Category:~SMOOTH_R_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~SMOOTH_R_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		Try
		(
			-------------------------------------------------------------------------------------------
			-- Switch to Motion Panel
			-------------------------------------------------------------------------------------------
		
			IF selection.count == 1 AND getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
			
			for node in selection do
			(
				local controllerClass = classof node.controller
				if not (controllerClass == BipSlave_Control or
						controllerClass == XRef_Controller or
						(controllerClass == IK_ControllerMatrix3Controller and 
						 node.controller[1].controller == undefined)) then
				(
					-------------------------------------------------------------------------------------------
					-- Skip group members, only apply to head
					-------------------------------------------------------------------------------------------
					local h = node.parent 
					if not (h != undefined and h.isSelected and isGroupHead h) then
					(				
						-------------------------------------------------------------------------------------------
						-- Add List Controller
						-------------------------------------------------------------------------------------------
						
						local cont = AddListController node "Rotation" Rotation_List 
						
						-------------------------------------------------------------------------------------------
						-- Add Constraint
						---------------------------------------------------------------------------------------
						If classof cont[listCtrl.GetActive cont].object != Smooth_Rotation then controller = AddConstraint node "Rotation" bezier_rotation true
							else controller = cont[listCtrl.GetActive cont].object
				
						-------------------------------------------------------------------------------------------
						-- Set Active Controller
						-------------------------------------------------------------------------------------------
								
						SetActiveController cont controller
						
						-- the script used to select the selected node here, but I don't see why, and 
						-- it would now break the loop on selected nodes
					)
				)
			)
		)
		Catch (MessageBox ~MSGBOX_SMOOTH_ROTATION_CONTROLLER_CAPTION~ Title:~MSGBOX_SMOOTH_ROTATION_CONTROLLER_TITLE~)

--		AssignControllerSelection Smooth_Rotation "Rotation" Rotation_List ~SMOOTH_ROTATION_LIST_CAPTION~
	)
)

MacroScript TCB_P
	ButtonText:~TCB_P_BUTTONTEXT~
	Category:~TCB_P_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~TCB_P_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection TCB_Position ~TCB_POSITION_CAPTION~ Position_List ~TCB_POSITION_LIST_CAPTION~			
	)
)



MacroScript TCB_R
	ButtonText:~TCB_R_BUTTONTEXT~
	Category:~TCB_R_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~TCB_R_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection TCB_Rotation ~TCB_ROTATION_CAPTION~ Rotation_List ~TCB_ROTATION_LIST_CAPTION~
	)
)

MacroScript TCB_S
	ButtonText:~TCB_S_BUTTONTEXT~
	Category:~TCB_S_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~TCB_S_TOOLTIP~
	SilentErrors:(Debug != True) 


(
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)

	on execute do 
	(
		AssignControllerSelection TCB_Scale ~TCB_SCALE_CAPTION~ Scale_List ~TCB_SCALE_LIST_CAPTION~
	)
)


MacroScript PRS
	ButtonText:~PRS_BUTTONTEXT~
	Category:~PRS_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~PRS_TOOLTIP~ 
	SilentErrors:(Debug != True)
	
(		
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)
	 
	on execute do 
	(
		Try 
		(
			-------------------------------------------------------------------------------------------
			-- Switch to Motion Panel
			-------------------------------------------------------------------------------------------
		
			IF selection.count == 1 AND getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
			
			for node in selection do
			(
				local controllerClass = classof node.controller
				if not (controllerClass == BipSlave_Control or
						controllerClass == XRef_Controller or
						(controllerClass == IK_ControllerMatrix3Controller and 
						 node.controller[1].controller == undefined)) then
				(
					-------------------------------------------------------------------------------------------
					-- Skip group members, only apply to head
					-------------------------------------------------------------------------------------------
					local h = node.parent 
					if not (h != undefined and h.isSelected and isGroupHead h) then
					(				
						local constraint
						constraint = node.Transform.controller
						if Classof constraint != prs() do
						(
							node.Transform.controller = prs()
						)
					)
				)
			)
				
		)
		Catch (MessageBox ~MSGBOX_PRS_CONTROLLER_NOT_COMPLETED_CAPTION~ Title:~MSGBOX_PRS_CONTROLLER_NOT_COMPLETED_TITLE~)
	)
)

MacroScript Transform_script
	ButtonText:~TRANSFORM_SCRIPT_BUTTONTEXT~
	Category:~TRANSFORM_SCRIPT_CATEGORY~ 
	internalCategory:"Controllers" 
	Tooltip:~TRANSFORM_SCRIPT_TOOLTIP~ 
	SilentErrors:(Debug != True)
	
(		
	-- Check to see if any valid node is selected
	on isEnabled do
	(
		IsValidControllerSelection()
	)
	 
	on execute do 
	(
		Try
		(
			-------------------------------------------------------------------------------------------
			-- Switch to Motion Panel
			-------------------------------------------------------------------------------------------
		
			IF selection.count == 1 AND getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
			
			for node in selection do
			(
				local controllerClass = classof node.controller
				if not (controllerClass == BipSlave_Control or
						controllerClass == XRef_Controller or
						(controllerClass == IK_ControllerMatrix3Controller and 
						 node.controller[1].controller == undefined)) then
				(
					-------------------------------------------------------------------------------------------
					-- Skip group members, only apply to head
					-------------------------------------------------------------------------------------------
					local h = node.parent 
					if not (h != undefined and h.isSelected and isGroupHead h) then
					(				
						local constraint
						constraint = node.Transform.controller
						if Classof constraint != transform_script() do
						(
							node.Transform.controller = transform_script()
						)
					)
				)
			)
				
		)
		Catch (MessageBox ~MSGBOX_TRANSFORM_SCRIPT_CONTROLLER_CAPTION~ Title:~MSGBOX_TRANSFORM_SCRIPT_CONTROLLER_TITLE~)
	)
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBzgYUd87qqnW13dSq/OEReZlPGmxOgO9vS
-- XMqxa9/KRKBSCgqtlE4io2D7f43ar5FWGhLX9xZUm9cP0l7FBQcN0bEo0voP7BZG
-- DA1ON+CAOmCg8Fqnd74muhbAZRhO77SifRw+Wsr0i+jx4/+xIvR2IVlU0rLhPuWE
-- GRwXCsTNuXXhgLuUZRBhqE2S/2xkgCyAZR50UZhtjZCcW/uqe3DOXnmH2VauGXw0
-- 1GsIW4QlcOoGDOn+Elcw6UbRa7qBwTUYblPTj+hdlwXJWkhYS+WyytrTJKOr5gU9
-- CYu7I0MryAS1xhpYOA0qfwrysiRqrbxLeRqqN5zlRRywGm38RUFo
-- -----END-SIGNATURE-----